<?php

namespace App\Http\Resources;

use App\Facades\Settings;
use Illuminate\Http\Resources\Json\JsonResource;

class LiveChatResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'widget' => $this->resource['widget'] ?? null,
            'data' => collect($this->resource['data'] ?? [])->map(fn ($setting) => Settings::get($setting))->toArray(),
        ];
    }
}
