<?php

namespace App\Http\Resources;

use App\Traits\HasPlaceholderImage;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\NewCar;

class NewCarListResource extends JsonResource
{
    use HasPlaceholderImage;

    public static $wrap = '';

    private Collection $placeholder;
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->placeholder = $this->getPlaceholderImage('new-car');
        if ($this->resource instanceof LengthAwarePaginator) {
            $this->resource->through(fn(NewCar $car) => $this->map($car));
        } else {
            $this->resource = $this->resource->map(fn(NewCar $car) => $this->map($car));
        }
        return parent::toArray($request);
    }

    protected function map(NewCar $car): array
    {
        $listingImage = $car->mediaUses
            ->filter(fn ($mediaUse) => $mediaUse->flags['listing'] ?? null)
            ->first();
        return [
            'slug' => $car->slug,
            'name' => $car->name,
            'derivative' => $car->derivative,
            'make' => $car->make->name,
            'model' => $car->model->name,
            'image' => $listingImage?->getUrl('tile') ?? $this->placeholder->first()['src_medium'],
            'price' => $car->price,
            'section_url' => $car->make->filterIndex->slug . '/' . $car->model->filterIndex->slug,
        ];
    }
}
