<?php

namespace App\Http\Resources;

use App\Facades\Settings;
use App\OfferRepository;
use App\Traits\HasPlaceholderImage;
use App\Traits\RetrievesContent;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Collection;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\Country;
use Mtc\MercuryDataModels\SeoDefault;
use Mtc\MercuryDataModels\VehicleOfferContent;

class OfferResource extends JsonResource
{
    use HasPlaceholderImage;
    use FranchiseData;
    use PhoneNumberDisplay;
    use RetrievesContent;

    public static $wrap = '';

    private const UI_RESOURCE_PREFIX = 'App\\Http\\Resources\\';

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->load([
            'mediaUses.media',
            'finance',
            'transmission',
            'fuelType',
            'bodyStyle',
            'drivetrain',
            'form.sections.questions',
            'content.mediaUses.media',
            'content.subContent.mediaUses.media',
            'content.subContent.subContent.mediaUses.media',
            'content.subContent.subContent.subContent.mediaUses.media',
            'content.contentElement',
            'content.globalContent.contentElement',
            'content.subContent.contentElement',
            'content.subContent.globalContent.contentElement',
            'content.subContent.subContent.contentElement',
            'content.subContent.subContent.globalContent.contentElement',
            'content.subContent.subContent.subContent.contentElement',
            'content.subContent.subContent.subContent.globalContent.contentElement',
        ]);
        $this->resource->media_uses = $this->resource->mediaUses->map(fn($mediaUse) => [
            'title' => $mediaUse->title,
            'alt_text' => $mediaUse->alt_text,
            'description' => $mediaUse->description,
            'caption' => $mediaUse->caption,
            'src_large' => $mediaUse->getUrl('large'),
            'src_medium' => $mediaUse->getUrl('medium'),
            'type' => $mediaUse->media->type
        ]);

        $this->resource->make_name = $this->resource->make?->name;
        $this->resource->model_name = $this->resource->model?->name;
        $this->resource->view_stock = false;

        $this->resource->forms = [
            'enquire' => $this->resource->form
                ? (new FormViewResource($this->resource->form))->setValues([ 'offer_id' => $this->resource->id ])
                : null,
        ];

        $this->resource->features = $this->resource->features->pluck('name');

        $resource = $this->resource->only([
            'name',
            'price',
            'make_name',
            'model_name',
            'derivative',
            'content',
            'media_uses',
            'forms',
            'finance',
            'specs',
            'features',
        ]);

        if (is_null($resource['media_uses']) || $resource['media_uses']->isEmpty()) {
            $resource['media_uses'] = $this->getPlaceholderImage('offer');
        }

        $resource['details'] = $this->getDetails();

        $resource['cross_sell'] = (new OfferRepository())->similar($this->resource);
        $resource['contact_number'] = $this->getContactNumber();
        $resource['content'] = $this->getContent($this->resource->content);
        $resource['seo'] = $this->fillSeo('offer');
        $resource['isFranchise'] = $this->isFranchise();
        $resource['franchise'] = $this->franchiseData();
        return $resource;
    }

    private function getDetails(): array
    {
        return [
            [
                'name' => __('labels.vehicle.colour'),
                'value' => $this->resource->colour
            ],
            [
                'name' => __('labels.vehicle.engine_size'),
                'value' => $this->resource->engine_size_cc ? $this->resource->engine_size_cc . 'cc' : null,
            ],
            [
                'name' => __('labels.vehicle.fuel_type'),
                'value' => $this->resource->fuelType?->name
            ],
            [
                'name' => __('labels.vehicle.body_style'),
                'value' => $this->resource->bodyStyle?->name
            ],
            [
                'name' => __('labels.vehicle.transmission'),
                'value' => $this->resource->transmission?->name
            ],
            [
                'name' => __('labels.vehicle.drivetrain'),
                'value' => $this->resource->drivetrain?->name
            ],
        ];
    }
}
