<?php

namespace App\Modules\Purchase\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Requests\ViewVehicleRequest;
use App\Http\Resources\VehicleResource;
use App\Modules\Purchase\Http\Requests\ContactDetailRequest;
use App\Modules\Purchase\Http\Requests\CreateInvoiceRequest;
use App\Modules\Purchase\Http\Requests\FailedPaymentRequest;
use App\Modules\Purchase\Http\Requests\PaymentOptionRequest;
use App\Modules\Purchase\Http\Requests\SuccessfulPaymentRequest;
use App\Modules\Purchase\Http\Resources\InvoiceResource;
use App\Modules\Purchase\Http\Resources\PaymentOptionsResource;
use App\Modules\Purchase\Http\Resources\VehicleDeliveryOptionsResource;
use App\Modules\Purchase\Http\Resources\VehicleExtrasResource;
use App\Modules\Purchase\PurchaseRepository;
use App\Repositories\NewsletterRepository;
use Illuminate\Http\Response;
use Mtc\MercuryDataModels\Vehicle;

class BuyVehicleController extends Controller
{
    public function showVehicle(
        ViewVehicleRequest $request,
        Vehicle $vehicle
    ): VehicleResource {
        return new VehicleResource($vehicle);
    }

    public function checkContactDetails(
        ContactDetailRequest $request,
        NewsletterRepository $newsletterRepository
    ): Response {
        if ($request->input('marketing_consent')) {
            $newsletterRepository->signUp($request->input('email'));
        }
        return response('ok');
    }

    public function getExtras(
        Vehicle $vehicle,
        PurchaseRepository $repository
    ): VehicleExtrasResource {
        return new VehicleExtrasResource($repository->extrasForVehicle($vehicle));
    }

    public function getDeliveryOptions(
        Vehicle $vehicle,
        PurchaseRepository $repository
    ): VehicleDeliveryOptionsResource {
        return new VehicleDeliveryOptionsResource($repository->getDeliveryOptions($vehicle));
    }

    public function getPaymentOptions(
        PaymentOptionRequest $request,
        Vehicle $vehicle,
        PurchaseRepository $repository
    ): PaymentOptionsResource {
        return new PaymentOptionsResource($repository->getPaymentOptions($request, $vehicle));
    }

    public function createInvoice(
        CreateInvoiceRequest $request,
        Vehicle $vehicle,
        PurchaseRepository $repository
    ): PaymentOptionsResource {
        return new InvoiceResource($repository->createInvoice($request, $vehicle));
    }

    public function successfulPayment(SuccessfulPaymentRequest $request)
    {
        return [

        ];
    }

    public function failedPayment(FailedPaymentRequest $request)
    {
        return [

        ];
    }
}
