<?php

namespace App\Modules\Purchase\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ContactDetailRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'email' => [
                'required',
                'email',
            ],
            'contact_no' => 'required',
            'address_1' => 'sometimes',
            'address_2' => 'sometimes',
            'city' => 'sometimes',
            'postcode' => 'sometimes',
            'state' => 'sometimes',
            'country' => 'sometimes',
        ];
    }
}
