<?php

namespace App\Modules\Purchase\Http\Requests;

use App\Facades\Feature;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class CreateInvoiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Feature::isEnabled('vehicle-purchase');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'preferred_delivery_date' => [
                'nullable',
                'date',
            ],
            'requires_finance' => [
                'nullable',
                'boolean',
            ],
            'type' => [
                'required',
                Rule::in(['purchase', 'reserve', 'finance']),
            ],
            'address.email' => [
                'required',
                'email',
            ],
            'address.first_name' => [
                'required',
            ],
            'address.last_name' => [
                'required',
            ],
            'extras' => [
                'array',
            ],
            'extras.*' => [
                'numeric'
            ],
            'details' => [
                'sometimes',
            ],
        ];
    }
}
