<?php

namespace App\Sales;

use App\Facades\Settings;
use Mtc\MercuryDataModels\Vehicle;

class SilverBullet
{
    public function getVehicleAction(Vehicle $vehicle, string $dealType = '')
    {
        return [
            'type' => 'component',
            'value' => 'CatalogSilverBulletDeal',
            'data' => [
                'action' => $dealType,
                'title' => Settings::get($this->getTitleSetting($dealType)),
                'url' => $this->url(Settings::get('sales-silver-bullet-domain'), $dealType),
                'id' => $vehicle->id,
                'vehicle_id' => $vehicle->uuid ?? $vehicle->id,
                'dealer_id' => $vehicle->dealership_id,
                'utm_source' => Settings::get('sales-silver-bullet-domain'),
                'utm_medium' => Settings::get('sales-silver-bullet-medium'),
                'utm_campaign' => Settings::get('sales-silver-bullet-campaign-name'),
                'vehicle_url' => '',
            ]
        ];
    }

    /**
     * Deal building url. Determined by type
     *
     * @param string|null $domain
     * @param string $dealType
     * @return string
     */
    private function url(?string $domain, string $dealType): string
    {
        return match ($dealType) {
            'finance' => rtrim($domain, '/') . '/start-finance/',
            'valuation' => rtrim($domain, '/') . '/start-trade-in/',
            default => rtrim($domain, '/') . '/start/',
        };
    }

    private function getTitleSetting(string $dealType)
    {
        return match ($dealType) {
            'finance' => 'sales-silver-bullet-finance-button-text',
            'valuation' => 'sales-silver-bullet-trade-in-button-text',
            'reserve' => 'sales-silver-bullet-reserve-button-text',
            default => 'sales-silver-bullet-deal-button-text',
        };
    }
}
