<?php

namespace App\Traits;

use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\Setting;

trait HasPlaceholderImage
{
    public function getPlaceholderImage(string $type): Collection
    {
        $dimensions = config(config("automotive.placeholder_media_sizes.placeholder-image-$type"));
        $mediaUses = Setting::query()->where('config_key', 'placeholder-image-' . $type)
            ->first()
            ?->mediaUses;

        return $mediaUses
            ? $mediaUses->map(fn($mediaUse) => [
                'title' => $mediaUse->title,
                'alt_text' => $mediaUse->alt_text,
                'description' => $mediaUse->description,
                'caption' => $mediaUse->caption,
                'src_large' => $mediaUse->getUrl($dimensions['large']),
                'src_medium' => $mediaUse->getUrl($dimensions['medium']),
                'type' => $mediaUse->media->type
            ])
            : collect([
                [
                    'src_large' => null,
                    'src_medium' => null,
                    'alt_text' => null,
                ]
            ]);
    }
}
