<?php

namespace Tests\Feature;

use App\Models\FilterIndex;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Franchise;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\Template;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleOffer;
use Tests\TestCase;

class FranchiseDataTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testFranchiseData()
    {
        tenant()->update(['tier' => 'pro']);
        $franchise = Franchise::factory()->create([
            'name' => 'foo',
            'slug' => 'baz'
        ]);

        $template = Template::factory()->create(['slug' => 'franchise']);
        $page = Page::factory()->create(['status' => 'published', 'template_id' => $template->id]);
        $response = $this->asTenant(tenant())
            ->getJson(route('pages.show', $page->slug));

        $response->assertStatus(200);
    }
}
