<?php

namespace App\Http\Resources\VehicleAction;

use App\Facades\Settings;
use App\Sales\SilverBullet;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\Vehicle;

class DealFactory
{
    public function get(Vehicle $vehicle)
    {
        if ($this->hasKeyloopValuation()) {
            return App::make(SilverBullet::class)->getVehicleAction($vehicle, 'deal');
        }
        return false;
    }

    private function hasKeyloopValuation(): bool
    {
        return Settings::get('sales-silver-bullet-enabled')
            && Settings::get('sales-silver-bullet-build-deal');
    }
}
