<?php

namespace App\Http\Resources\VehicleAction;

use App\Facades\Settings;
use App\Sales\CodeWeavers;
use App\Sales\SilverBullet;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\Vehicle;

class ReserveFactory
{
    public function get(Vehicle $vehicle)
    {
        if ($this->hasKeyloopValuation()) {
            return App::make(SilverBullet::class)->getVehicleAction($vehicle, 'reserve');
        }

        if ($this->hasCodeWeaversReservation()) {
            return App::make(CodeWeavers::class)->getVehicleAction($vehicle, 'reserve');
        }

        return false;
    }

    private function hasKeyloopValuation(): bool
    {
        return Settings::get('sales-silver-bullet-enabled')
            && Settings::get('sales-silver-bullet-reserve');
    }

    private function hasCodeWeaversReservation(): bool
    {
        return true;
        return Settings::get('sales-silver-bullet-enabled')
            && Settings::get('sales-silver-bullet-reserve');
    }
}
