<?php

namespace App\Http\Resources;

use App\Facades\Settings;
use App\Http\Resources\VehicleAction\LoadsVehicleActions;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Vehicle;

class VehicleQuickViewResource extends JsonResource
{
    use LoadsVehicleActions;

    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->resource->id,
            'title' => $this->resource->title,
            'derivative' => $this->resource->derivative,
            'slug' => $this->resource->slug,
            'is_new' => $this->resource->is_new,
            'price' => $this->resource->price,
            'monthly_price' => $this->resource->monthly_price,
            'make_id' => $this->resource->make_id,
            'thumbnail' => [
                'small' => $this->resource->getPreviewImage('325x250'),
            ],
            'actions' => $this->getVehicleActions($this->resource),
            'odometer_mi' => $this->resource->odometer_mi,
            'odometer_km' => $this->resource->odometer_km,
            'fuel_type' => $this->resource->fuelType?->name,
            'transmission' => $this->resource->transmission?->name,
            'body_style' => $this->resource->bodyStyle?->name,
            'make' => Settings::get('automotive-vehicle-brand-on-filter-card')
                ? [
                    'name' => $this->resource->make->name ?? '',
                    'logo' => $this->resource->make->logo ?? '',
                ]
                : null,
            'location' => $this->locationValue($this->resource),
            'deposit' => $this->resource->deposit,
        ];
    }

    private function locationValue(Vehicle $vehicle): string
    {
        if (tenant()->hasMultipleLocations()) {
            return $vehicle->dealership->name ?? '';
        }

        return '';
    }
}
