<?php

namespace App;

use App\Http\Resources\OfferListResource;
use Mtc\MercuryDataModels\VehicleOffer;

class OfferRepository
{
    public function similar(VehicleOffer $offer, int $limit = 4, string $matchType = 'price'): OfferListResource
    {
        return new OfferListResource(
            VehicleOffer::query()
                ->with([
                    'make.filterIndex',
                    'model.filterIndex',
                    'primaryMediaUse.media',
                    'dealership',
                ])
                ->active()
                ->similar($matchType, $offer)
                ->where('id', 'not like', $offer->id)
                ->take($limit * 2)
                ->get()
                ->shuffle()
                ->take($limit)
        );
    }
}
