<?php

namespace App\Sales;

use App\Facades\Settings;
use App\Traits\HasPlaceholderImage;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleFinance;

class CodeWeavers
{
    use HasPlaceholderImage;

    public function getVehicleAction(Vehicle $vehicle, string $dealType = '')
    {
        return [
            'type' => 'component',
            'value' => 'CatalogCodeWeaversDeal',
            'data' => [
                'title' => 'Reserve for £99',
//                'title' => Settings::get($this->getTitleSetting($dealType)),
                'url' => $this->url($vehicle, $dealType),
            ]
        ];
    }

    private function url(Vehicle $vehicle, string $dealType): string
    {


        return 'https://newvehicle.com/widgets/lib/reserve-vehicle-cta/loader.js?' . collect([
                'scrollToSelector' => '',
                'callToActionStyle' => 3,
                'username' => Settings::get('finance-codeweavers-username'),
//                'quoteeUid' => '3374A502-CFCF-4B42-BC97-EDA65E7D21A8',
                'quoteeUid' => strtoupper($this->getQuoteId($vehicle->financeExamples()->first())),
                'class' => $vehicle->type,
                'condition' => 'used',
                'vrm' => str_replace(' ', '', $vehicle->registration_number),
                'registrationDate' => $vehicle->first_registration_date->format('d/m/Y'),
                'capCode' => '',
                'capId' => $vehicle->cap_id,
                'cashPrice' => (int)$vehicle->price,
                'vatIncluded' => '',
                'vatQualifying' => '',
                'currentOdometerReading' => $vehicle->odometer_mi,
                'vehicleImageUrl' => $vehicle->primaryMediaUse?->getUrl('900x600')
                    ?? $this->getPlaceholderImage('vehicle')->first()['src_medium'],
                'term' => Settings::get('finance-term'),
                'cashDepositType' => 'Percentage',
                'cashDeposit' => Settings::get('finance-deposit_percentage'),
                'annualDistance' => Settings::get('finance-annual_mileage'),
                'dateOnForecourt' => $vehicle->stock_arrival_date?->format('d/m/Y'),
            ])->map(fn($value, $key) => "$key=$value")->implode('&');
    }

    private function getTitleSetting(string $dealType)
    {
        return match ($dealType) {
            'reserve' => 'sales-codeweavers-reserve-button-text',
            default => 'sales-codeweavers-deal-button-text',
        };
    }

    private function mapActionType(string $dealType)
    {
        return match ($dealType) {
            'reserve' => 'reserve-vehicle',
            default => 'start',
        };
    }

    private function getQuoteId(?VehicleFinance $quote)
    {
        if ($quote === null) {
            return null;
        }
        return str_replace(
            ['https://services.codeweavers.net/forms/quote/', '/apply'],
            '',
            $quote->apply_url
        );
    }
}
