<?php

namespace Tests\Feature;

use App\Models\FilterIndex;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleOffer;
use Tests\TestCase;

class DealershipControllerTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testDealershipIndex()
    {
        Dealership::factory(3)->create();
        $response = $this->asTenant(tenant())
            ->getJson(route('dealerships.index'));

        $response->assertStatus(200);
        $this->assertArrayHasKey('page', $response->json());
        $this->assertArrayHasKey('dealerships', $response->json());
    }

    public function testDealershipShow()
    {
        $dealership = Dealership::factory()->create();
        $response = $this->asTenant(tenant())
            ->getJson(route('dealerships.show', $dealership));

        $response->assertStatus(200);
    }
}
