<?php

namespace Tests\Feature;

use App\Modules\Stock\Motordat;
use App\Sales\SilverBullet;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\App;
use Mtc\ContentManager\Models\Media;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TestCase;

class SilverBulletTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testVehicleAction()
    {
        $vehicle = Vehicle::factory()->create();
        /** @var SilverBullet $service */
        $service = App::make(SilverBullet::class);

        $widget = $service->getVehicleAction($vehicle, 'finance');
        $this->assertIsArray($widget);
        $this->assertArrayHasKey('type', $widget);
        $this->assertArrayHasKey('value', $widget);
        $this->assertArrayHasKey('data', $widget);
        $this->assertArrayHasKey('url', $widget['data']);
    }

    public function testUrl()
    {
        $vehicle = Vehicle::factory()->create();
        /** @var SilverBullet $service */
        $service = App::make(SilverBullet::class);

        $widget = $service->getVehicleAction($vehicle, 'finance');
        $this->assertStringContainsString('/start-finance/', $widget['data']['url']);
        $widget = $service->getVehicleAction($vehicle, 'valuation');
        $this->assertStringContainsString('/start-trade-in/', $widget['data']['url']);
        $widget = $service->getVehicleAction($vehicle, 'sale');
        $this->assertStringContainsString('/start/', $widget['data']['url']);
    }
}
