<?php

namespace App\Http\Resources;

use App\TierHelper;
use Mtc\MercuryDataModels\Franchise;
use Mtc\MercuryDataModels\Menu;

trait FranchiseData
{
    protected function getFranchiseList(): array
    {
        if (!$this->tenantIsAllowedFranchises()) {
            return [];
        }

        return Franchise::query()->select(['name', 'slug'])->get()->toArray();
    }

    protected function isFranchise(): bool
    {
        if (!$this->tenantIsAllowedFranchises() || empty($this->resource)) {
            return false;
        }

        if (!empty($this->resource->franchise_id)) {
            return true;
        }

        return $this->resource?->template?->slug === 'franchise';
    }

    protected function franchiseData(): ?array
    {
        if ($this->isFranchise() !== true) {
            return null;
        }

        $franchise = Franchise::query()
            ->with([
                'menus',
                'make.filterIndex'
            ])
            ->find($this->resource->franchise_id);
        if (!$franchise) {
            return null;
        }
        $franchiseData = $franchise?->only([
            'name',
            'slug',
            'logo',
            'primary_colour',
            'secondary_colour',
            'menus',
            'make_id',
        ]);

        $franchiseData['logo'] = $franchise->mediaUse?->media?->original_url;
        $franchiseData['menus'] = $franchise->menus->map(fn(Menu $menu) => new MenuResource($menu));
        $franchiseData['make_slug'] = $franchise->make?->filterIndex?->slug;

        return $franchiseData;
    }


    protected function getFranchiseId(): int
    {
        return 0;
    }

    protected function tenantIsAllowedFranchises(): bool
    {
        return TierHelper::isAllowed(tenant()->tier, 'pro');
    }
}
