<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UiHero extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $image = $this->resource->subContent
            ->where('slug', 'image')
            ->first()
            ->mediaUses
            ->first();

        return [
            'image' => $image ? [
                'src' => $image->getUrl('full-width-banner'),
                'alt' => $image->alt_text,
            ] : null,
            'title' => $this->resource->subContent->where('slug', 'title')->first()->content,
            'search' => $this->resource->subContent->where('slug', 'search')->first()?->content,
            'brands' => (new UiBrands($this->resource->subContent->where('slug', 'brands')?->first()))
                ->toArray($request),
            'reviewsBadge' => $this->resource->subContent->where('slug', 'reviews-badge')->first()?->subContent
                ->first()?->content,
        ];
    }
}
