<?php

namespace App\Http\Resources\VehicleAction;

use App\Http\Resources\FormViewResource;
use Mtc\MercuryDataModels\Form;
use Mtc\MercuryDataModels\Vehicle;

trait LoadsVehicleActions
{
    public function getVehicleActions(Vehicle $vehicle): array
    {
        return [
            'reserve' => $this->reserveAction($vehicle),
            'deal' => $this->salesAction($vehicle),
            'finance' => $this->financeAction($vehicle),
            'enquiry' => $this->enquireAction($vehicle),
            'valuation' => $this->valuationAction($vehicle),
        ];
    }

    private function valuationAction(Vehicle $vehicle)
    {
        return (new ValuationFactory())->get($vehicle);
    }

    private function enquireAction(Vehicle $vehicle): ?array
    {
        $form = Form::query()
            ->with('sections.questions')
            ->whereHas('type', fn($query) => $query->where('name', 'Vehicle Enquiry'))
            ->first();
        return [
            'type' => 'form',
            'title' => 'Make an enquiry',
            'details' => $form
                ? (new FormViewResource($form))->setValues(['vehicle_id' => $vehicle->id])
                : [],
        ];
    }

    private function financeAction(Vehicle $vehicle): bool|array
    {
        return (new FinanceFactory())->get($vehicle);
    }

    private function reserveAction(Vehicle $vehicle): bool|array
    {
        return (new ReserveFactory())->get($vehicle);
    }

    private function salesAction()
    {
        return (new DealFactory())->get(($this->resource));
    }
}
