<?php

namespace Tests;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FilterSettingSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        foreach ($this->getData() as $setting) {
            Settings::make($setting);
        }
    }

    private function getData(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Make',
                'config_key' => 'automotive-vehicle-filters-make',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Consumption',
                'config_key' => 'automotive-vehicle-filters-consumption',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Model',
                'config_key' => 'automotive-vehicle-filters-model',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Body Style',
                'config_key' => 'automotive-vehicle-filters-body_type',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Price',
                'config_key' => 'automotive-vehicle-filters-price',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Manufacture Year',
                'config_key' => 'automotive-vehicle-filters-age',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Colour',
                'config_key' => 'automotive-vehicle-filters-colour',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Door Count',
                'config_key' => 'automotive-vehicle-filters-door_count',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Engine Size',
                'config_key' => 'automotive-vehicle-filters-engine_size',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Fuel Type',
                'config_key' => 'automotive-vehicle-filters-fuel_type',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Transmission Type',
                'config_key' => 'automotive-vehicle-filters-transmission',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Location',
                'config_key' => 'automotive-vehicle-filters-location',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Mileage',
                'config_key' => 'automotive-vehicle-filters-mileage',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Seat Count',
                'config_key' => 'automotive-vehicle-filters-seats',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Filter Search Term',
                'config_key' => 'automotive-vehicle-filters-search',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Price Point',
                'config_key' => 'automotive-vehicle-filters-price_point',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Price Max',
                'config_key' => 'automotive-vehicle-filters-price_max',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Price Min',
                'config_key' => 'automotive-vehicle-filters-price_min',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Engine Size Min',
                'config_key' => 'automotive-vehicle-filters-engine_size_min',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Engine Size Max',
                'config_key' => 'automotive-vehicle-filters-engine_size_max',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Mileage Min',
                'config_key' => 'automotive-vehicle-filters-mileage_min',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Mileage Max',
                'config_key' => 'automotive-vehicle-filters-mileage_max',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Manufacture Year Min',
                'config_key' => 'automotive-vehicle-filters-manufacture_year_min',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Manufacture Year Max',
                'config_key' => 'automotive-vehicle-filters-manufacture_year_max',
                'type' => 'boolean',
                'value' => true,
            ],
        ];
    }
}
