<?php

namespace App\Http\Controllers;

use App\Http\Requests\TrackConversionRequest;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Relations\Relation;
use Mtc\MercuryDataModels\Conversion;

class ConversionController extends Controller
{
    public function store(TrackConversionRequest $request)
    {
        $modelClass = Relation::getMorphedModel($request->input('model'));
        $model = $modelClass::query()->find($request->input('id'));
        Conversion::track($model, $request->input('type'), Carbon::now());
        return response('ok');
    }
}
