<?php

namespace App\Http\Controllers;

use App\Http\Resources\PageResource;
use Mtc\ContentManager\Models\Page;

class PageController extends Controller
{
    /**
     * Show page detail
     *
     * @param $page
     * @return PageResource
     */
    public function show($pageSlug): PageResource
    {
        // Not using binding in route as to allow for Seo Redirect middleware
        $page = Page::query()->where('slug', $pageSlug)->active()->firstOrFail();
        return new PageResource($page);
    }
}
