<?php

namespace App\Http\Controllers;

use App\Http\Requests\ValuationRequest;
use App\Http\Resources\PageResource;
use App\Http\Resources\ValuationResource;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Mtc\ContentManager\Models\Page;
use Mtc\VehicleValuation\Facades\Valuation;

class ValuationController extends Controller
{
    public function show(): PageResource|Response
    {
        if (!Valuation::hasEnabledDriver()) {
            return response('Valuations not available', 404);
        }

        $page = Page::query()->where('slug', 'valuation')->active()->firstOrFail();
        return new PageResource($page);
    }

    public function get(ValuationRequest $request): ValuationResource
    {
        $valuation = Valuation::get($request->input('registration_number'), $request->input('mileage'));
        if ($valuation->wasRecentlyCreated) {
            $valuation->update([
                'user_id' => Auth::id(),
            ]);
        }
        return new ValuationResource($valuation);
    }
}
