<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Mtc\MercuryDataModels\SeoRedirect;

class SeoRedirectCheckMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (($redirect = $this->checkRedirect($request)) !== null) {
            return response([
                'type' => 'redirect',
                'to' => $redirect->to,
                'code' => $redirect->code
            ], 404);
        }
        return $next($request);
    }

    /**
     * @param Request $request
     * @return Model|SeoRedirect|null
     */
    private function checkRedirect(Request $request): ?SeoRedirect
    {
        return SeoRedirect::query()
            ->where('from', $request->header('x-path'))
            ->first();
    }
}
