<?php

namespace App;

use App\Http\Resources\OfferListResource;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\VehicleOffer;

class PageRepository
{
    public function listing(?string $type, int $limit = 6, string $orderBy = 'published_at')
    {
        return Page::query()
            ->with('primaryMediaUse.media')
            ->where('category', $type)
            ->take($limit)
            ->orderBy($orderBy)
            ->get();
    }
}
