<?php

namespace App\Modules\PlaceholderImages;

use App\Facades\Settings;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\KeyloopLeaseVehicleVariant;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;
use Mtc\MercuryDataModels\VehicleTrim;

class ImaginStudio
{
    public function getForVehicle(Vehicle $vehicle, ?int $angle = 1): string
    {
        return 'https://cdn.imagin.studio/getImage?' . http_build_query([
                'customer' => $this->getCustomerValue(),
                'make' => $vehicle->make?->name,
                'modelFamily' => $vehicle->model?->name,
                'modelVariant' => $vehicle->derivative,
                'modelYear' => $vehicle->manufacture_year,
                'powerTrain' => $vehicle->fuelType?->name,
                'transmission' => $vehicle->transmissionType?->name,
                'bodySize' => $vehicle->bodyStyle?->name,
                'angle' => $angle,
                'paintdescription' => $vehicle->colour,
                'aspectRatio' => '16:9',
                'zoomLevel' => $this->getZoomLevel(),
            ]);
    }

    public function getForOffer(VehicleOffer $offer, ?int $angle = 1): string
    {
        return 'https://cdn.imagin.studio/getImage?' . http_build_query([
                'customer' => $this->getCustomerValue(),
                'make' => $offer->make?->name,
                'modelFamily' => $offer->model?->name,
                'powerTrain' => $offer->fuelType?->name,
                'transmission' => $offer->transmissionType?->name,
                'bodySize' => $offer->bodyStyle?->name,
                'paintdescription' => $offer->colour,
                'angle' => $angle,
                'aspectRatio' => '3:2',
                'zoomLevel' => $this->getZoomLevel(),
            ]);
    }

    public function getForNewCar(NewCar $newCar, ?int $angle = 1): string
    {
        return 'https://cdn.imagin.studio/getImage?' . http_build_query([
                'customer' => $this->getCustomerValue(),
                'make' => $newCar->make?->name,
                'modelFamily' => $newCar->model?->name,
                'powerTrain' => $newCar->fuelType?->name,
                'transmission' => $newCar->transmissionType?->name,
                'bodySize' => $newCar->bodyStyle?->name,
                'paintdescription' => $newCar->colour,
                'angle' => $angle,
                'aspectRatio' => '3:2',
                'zoomLevel' => $this->getZoomLevel(),
            ]);
    }
    public function getForNewCarTrim(VehicleTrim $trim, ?int $angle = 1): string
    {
        $colours = array_map(fn($colour) => $colour['name'], $trim->colours);
        $index = count($colours) > 0 ? array_rand($colours) : 0;
        return 'https://cdn.imagin.studio/getImage?' . http_build_query([
                'customer' => $this->getCustomerValue(),
                'make' => $trim->make?->name,
                'modelVariant' => $trim->name,
                'modelFamily' => $trim->model?->name,
                'paintdescription' => $colours[$index] ?? null,
                'angle' => $angle,
                'aspectRatio' => '3:2',
                'zoomLevel' => $this->getZoomLevel(),
            ]);
    }

    public function getForLeaseVehicle(KeyloopLeaseVehicleVariant $vehicle, ?int $angle = 1): string
    {
        return 'https://cdn.imagin.studio/getImage?' . http_build_query([
                'customer' => $this->getCustomerValue(),
                'make' => $vehicle->make?->name,
                'modelFamily' => $vehicle->model?->name,
                'modelVariant' => $vehicle->derivative,
                'modelYear' => $vehicle->manufacture_year,
                'powerTrain' => $vehicle->fuelType?->name,
                'transmission' => $vehicle->transmissionType?->name,
                'bodySize' => $vehicle->bodyStyle?->name,
                'angle' => $angle,
                'paintdescription' => $vehicle->colour,
                'aspectRatio' => '16:9',
                'zoomLevel' => $this->getZoomLevel(),
            ]);
    }

    public function getForOther(string $make, string $model, ?string $colour): string
    {
        return 'https://cdn.imagin.studio/getImage?' . http_build_query([
                'customer' => $this->getCustomerValue(),
                'make' => $make,
                'modelFamily' => $model,
                'paintdescription' => $colour,
                'aspectRatio' => '16:10',
                'zoomLevel' => $this->getZoomLevel(),
            ]);
    }

    public function getBaseUrl(): string
    {
        return 'https://cdn.imagin.studio/getImage?' . http_build_query([
                'customer' => $this->getCustomerValue(),
            ]);
    }

    /**
     * Return the value that Imagin Studio require for the 'customer' URL parameter
     * @return string
     */
    private function getCustomerValue(): string
    {
        return Settings::get('imagin-placeholders-client-key') ?? config('services.imagin-studio.key');
    }

    private function getZoomLevel(): string
    {
        return Settings::get('imagin-placeholders-zoom-level', '');
    }
}
