<?php

namespace Tests\Feature;

use App\Facades\Feature;
use App\Facades\Settings;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\ReservationPrice;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleMake;
use Tests\TestCase;

class ReservationPriceRuleTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testRuleDisabled()
    {
        Feature::setEnabled(tenant(), ['reservation-price-rules']);
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'sales-reserve_price',
            'value' => 99,
            'type' => 'number',
        ]);
        $make = VehicleMake::factory()->create();
        $make2 = VehicleMake::factory()->create();
        $rule = ReservationPrice::query()->create([
            'label' => 'foo',
            'price' => 250,
            'active' => false,
        ]);

        $rule->rules()->create([
            'field' => 'make_id',
            'condition' => '=',
            'value' => $make->id,
        ]);

        $vehicle = Vehicle::factory()->create(['make_id' => $make->id]);
        $vehicle2 = Vehicle::factory()->create(['make_id' => $make2->id]);

        $this->assertEquals(99, $vehicle->getReservationAmount());
        $this->assertEquals(99, $vehicle2->getReservationAmount());
    }

    public function testRuleEnabled()
    {
        Feature::setEnabled(tenant(), ['reservation-price-rules']);
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'sales-reserve_price',
            'value' => 99,
            'type' => 'number',
        ]);
        $make = VehicleMake::factory()->create();
        $make2 = VehicleMake::factory()->create();
        $rule = ReservationPrice::query()->create([
            'label' => 'foo',
            'price' => 250,
            'active' => true,
        ]);

        $rule->rules()->create([
            'field' => 'make_id',
            'condition' => '=',
            'value' => $make->id,
        ]);

        $vehicle = Vehicle::factory()->create(['make_id' => $make->id]);
        $vehicle2 = Vehicle::factory()->create(['make_id' => $make2->id]);

        $this->assertEquals(250, $vehicle->getReservationAmount());
        $this->assertEquals(99, $vehicle2->getReservationAmount());
    }
}
