<?php

namespace App\Http\Resources;

use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\Label;

trait FormatsLabelsForDisplay
{
    public function formatLabelsForDisplay(Collection $labels)
    {
        return $labels
            ->filter(fn ($label) => $label instanceof Label)
            ->map(fn ($label) => [
                'category' => $label->category ?? '',
                'content' => $label->content ?? '',
                'franchise_id' => $label->franchise_id ?? '',
                'id' => $label->id ?? '',
                'name' => $label->name ?? '',
                'type' => $label->type ?? '',
        ]);
    }
}
