<?php

namespace App\Modules\Payment;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Mtc\Checkout\Contracts\PayableContract;
use Mtc\Checkout\Contracts\PayableFactoryContract;

class PayableFactory implements PayableFactoryContract
{
    public function create(Request $request): PayableContract
    {
        switch ($request->input('type')) {
            case 'basket':
                return App::make(ReservationFactory::class)->create($request->input());
                break;
        }
        throw new \Exception("Unsupported Payment Object");
    }
}
