<?php

namespace App\Http\Controllers;

use App\EnquiryFormHandler;
use App\Http\Requests\PartialEnquirySubmissionRequest;
use App\Http\Requests\SubmitEnquiryRequest;
use Illuminate\Http\Response;

class EnquiryController extends Controller
{
    /**
     * Handle submitting a new enquiry from site
     *
     * @param SubmitEnquiryRequest $request
     * @param EnquiryFormHandler $manager
     * @return string[]
     */
    public function store(SubmitEnquiryRequest $request, EnquiryFormHandler $manager): array
    {
        return $manager->handle($request);
    }

    public function step(PartialEnquirySubmissionRequest $request, EnquiryFormHandler $manager): Response
    {
        return response([
            'enquiry_id' => $manager->partialSubmit($request)->id
        ], 201);
    }
}
