<?php

namespace App\Http\Resources;

use App\Traits\ContentMappingTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Collection;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\Models\MediaSize;
use Mtc\MercuryDataModels\Form;

class GlobalContentResource extends JsonResource
{
    use ContentMappingTrait;

    public static $wrap = '';

    protected bool $v2;

    public function __construct($resource, bool $v2 = false)
    {
        parent::__construct($resource);
        $this->v2 = $v2;
    }

    public function toArray($request): array
    {
        $this->resource->load('mediaUses.media');
        return collect($this->resource->content)
            ->map(fn($entry) => $this->mapContent($entry, $request))
            ->toArray();
    }

    private function mapContent($entry, $request)
    {
        $fieldType = $entry['field_type'] ?? '';
        $content = $entry['content'] ?? null;

        if ($fieldType === 'form-field') {
            $content = (new FormViewResource(Form::query()->find($content)))
                ->setValues([
                    'offer_id' => $request->input('offer_id'),
                    'vehicle_id' => $request->input('vehicle_id'),
                    'page_id' => $request->input('page_id'),
                    'valuation_id' => $request->input('valuation_id'),
                ]);
        } elseif ($fieldType === 'image') {
            $content = $this->resource->mediaUses
                ->filter(fn(MediaUse $mediaUse) => in_array($mediaUse->media_id, $entry['content'] ?? []))
                ->map(fn($mediaUse) => [
                    'src' => $mediaUse->getUrl('square-tile'),
                    'sizes' => $this->allSizesForUse($this->resource, $mediaUse),
                    'alt' => $mediaUse->alt_text,
                    'caption' => $mediaUse->caption,
                    'title' => $mediaUse->title,
                ])->all();
        }

        $children = !empty($entry['children'])
            ? collect($entry['children'])->map(fn($child) => $this->mapContent($child, $request))
            : collect();

        return $this->v2 ? [
            'ui_component' => $entry['ui_component'] ?? $this->guessUiComponent($fieldType),
            'name' => $entry['name'] ?? '',
            'slug' => $entry['slug'] ?? '',
            'value' => $this->mapValue($content, $fieldType, $this->resource->mediaUses, $this->resource),
            'data' => $children->all(),
        ] : [
            'field_type' => $fieldType,
            'content' => $content,
            'children' => $children->all(),
        ];
    }
}
