<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UiHero extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->load([
            'subContent.mediaUses',
        ]);

        $image = $this->resource->subContent
            ->where('slug', 'image')
            ->first()
            ->mediaUses
            ->first();

        $imageMobile = $this->resource->subContent
            ->where('slug', 'image-mobile')
            ->first()
            ?->mediaUses
            ->first();

        return [
            'image' => $image ? [
                'src' => $image->getUrl('full-width-banner'),
                'alt' => $image->alt_text,
                'original' => $image->media->getOriginalUrlAttribute(),
            ] : null,
            'imageMobile' => $imageMobile ? [
                'src' => $imageMobile->getUrl('hero-mobile'),
                'alt' => $imageMobile->alt_text,
                'original' => $imageMobile->media->getOriginalUrlAttribute(),
            ] : null,
            'title' => $this->resource->subContent->where('slug', 'title')->first()->content,
            'search' => $this->resource->subContent->where('slug', 'search')->first()?->content,
            'brands' => (new UiBrands($this->resource->subContent->where('slug', 'brands')?->first()))
                ->toArray($request),
            'reviewsBadge' => $this->resource->subContent->where('slug', 'reviews-badge')->first()?->subContent
                ->first()?->content,
        ];
    }
}
