<?php

namespace App\Http\Resources;

use App\PageRepository;
use Illuminate\Http\Resources\Json\JsonResource;

class UiNewsCardList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->load([
            'subContent',
        ]);

        $articleType = $this->resource->subContent
            ->where('slug', 'article-type')
            ->first();

        return (new PageListResource(
            (new PageRepository())->listing(
                type: $articleType->content['value'] ?? null,
                filters: $request->input('filters')
            ),
        ))->toArray($request);
    }
}
