<?php

namespace App\Traits;

use App\Http\Resources\FormViewResource;
use Illuminate\Support\Collection;
use Mtc\ContentManager\Contracts\Content;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\MercuryDataModels\GlobalContent;
use Mtc\ContentManager\Models\MediaSize;
use Mtc\MercuryDataModels\Form;

trait ContentMappingTrait
{
    protected Collection $mediaSizes;

    private function mapValue($content, $fieldId, $mediaUses = null, Content|GlobalContent|null $context = null)
    {
        if ($context instanceof Content && $this->componentHasUiResource($context)) {
            $contentResource = $this->getUiResource($context);
            return new $contentResource($context);
        }

        return match ($fieldId ?? '') {
            'image', 'images' => collect($mediaUses ?? [])
                ->map(fn($mediaUse) => [
                    'src' => $mediaUse->getUrl('square-tile'),
                    'sizes' => $this->allSizesForUse($context, $mediaUse),
                    'alt' => $mediaUse->alt_text,
                    'caption' => $mediaUse->caption,
                    'title' => $mediaUse->title,
                ])->all(),
            'form-field' => new FormViewResource(Form::query()
                ->with('sections.questions')
                ->where('id', $content instanceof Content ? $content->content : $content)
                ->first()),
            default => $content instanceof Content ? $content->content : $content
        };
    }

    private function allSizesForUse(Content|GlobalContent|null $content, MediaUse $mediaUse): Collection
    {
        if (!isset($this->mediaSizes)) {
            $this->mediaSizes = MediaSize::query()
                ->where('model', $content ? $content->getMorphClass() : 'global-content')
                ->get();
        }
        return $this->mediaSizes
            ->keyBy('label')
            ->map(fn(MediaSize $size) => $mediaUse->getUrl($size->label))
            ->put('original', $mediaUse->media->getOriginalUrlAttribute());
    }

    private function guessUiComponent($fieldId): ?string
    {
        return match ($fieldId ?? '') {
            'text-content', 'text_area' => 'UiArticleText',
            'image', 'images' => 'UiArticleBanner',
            'form-field' => 'UiForm',
            default => null,
        };
    }

    private function componentHasUiResource(Content $content): bool
    {
        if (!empty($content->global_content_id)) {
            return !empty($content->globalContent->ui_component)
                && class_exists(self::UI_RESOURCE_PREFIX . $content->globalContent->ui_component);
        }

        return !empty($content->contentElement->ui_component)
            && class_exists(self::UI_RESOURCE_PREFIX . $content->contentElement->ui_component);
    }
}
