<?php

namespace Tests\Feature;

use App\Facades\Settings;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Mtc\VehicleReservations\Reservation;
use Tests\TestCase;

class ReservationTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testReservationData()
    {
        $this->seed();

        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'app-details-currency',
            'value' => 'GBC',
            'type' => 'string',
        ]);

        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'sales-stripe-public_key',
            'value' => 'foo',
            'type' => 'string',
        ]);

        $make = VehicleMake::factory()->create();
        $model = VehicleModel::factory()->create();
        $vehicle = Vehicle::factory()->create([
            'registration_number' => 'ABC123',
            'make_id' => $make->id,
            'model_id' => $model->id,
            'derivative' => 'foo',
            'price' => 789
        ]);

        $response = $this->asTenant(tenant())
            ->postJson('frontend/reservations/' . $vehicle->slug, [
                'name' => 'test',
                'email' => 'test@test.com',
            ]);

        $response->assertStatus(201);

        $this->assertCount(1, Reservation::all());

        $reservation = Reservation::query()->first();
        $expected_string = $vehicle->registration_number . ' ' . $make->name . ' ' . $model->name . ' foo 789';

        $this->assertIsArray($reservation->data);
        $this->assertArrayHasKey('vehicle', $reservation->data);
        $this->assertArrayHasKey('description', $reservation->data['vehicle']);
        $this->assertEquals($expected_string, $reservation->data['vehicle']['description']);
    }
}
