<?php

namespace App\Http\Resources;

use App\Facades\Settings;
use Illuminate\Http\Resources\Json\JsonResource;

class SocialMetaResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request): array
    {
        return [
            'og_title' => $this->getSocialMetaData(
                'seo-meta-data-og-title',
                $this->resource['title'] ?? ''
            ),
            'og_description' => $this->getSocialMetaData(
                'seo-meta-data-og-description',
                $this->resource['description'] ?? ''
            ),
            'og_url' => $this->getSocialMetaData(
                'seo-meta-data-og-url',
                request()->header('origin') . request()->header('x-path')
            ),
            'twitter_title' => $this->getSocialMetaData(
                'seo-meta-data-twitter-title',
                $this->resource['title'] ?? ''
            ),
            'twitter_description' => $this->getSocialMetaData(
                'seo-meta-data-twitter-description',
                $this->resource['description'] ?? ''
            ),
        ];
    }

    /**
     * Helper method to check settings or fall back to the resource.
     *
     * @param string $settingKey
     * @param string $resourceValue
     * @return mixed
     */
    private function getSocialMetaData(string $settingKey, string $resourceValue): string
    {
        return Settings::get($settingKey, '') ?: $resourceValue;
    }
}
