<?php

namespace App\Http\Controllers;

use App\Http\Requests\DerivativeLookupRequest;
use App\Http\Requests\LookupRequest;
use App\Http\Resources\LookupResource;
use App\Http\Resources\VehicleTrimListResource;
use Illuminate\Http\Response;
use Mtc\MercuryDataModels\VehicleTrim;
use Mtc\VehicleLookup\VehicleLookupService;

class LookupController extends Controller
{
    public function show(LookupRequest $request, VehicleLookupService $lookupService): LookupResource
    {
        $lookup = $lookupService->findByVRM(
            $request->input('registration_number'),
            $request->input('mileage')
        );

        return new LookupResource($lookup);
    }

    public function getVariants(DerivativeLookupRequest $request, VehicleLookupService $service): Response
    {
        return response($service->findVariants($request->make(), $request->model()));
    }

    public function getTrims(DerivativeLookupRequest $request): VehicleTrimListResource
    {
        $trims = VehicleTrim::query()
            ->where('active', 1)
            ->where('make_id', '=', $request->make()->id)
            ->where('model_id', '=', $request->model()->id)
            ->where('full_price', '>', 0)
            ->whereNotNull('cap_id')
            ->get();

        return new VehicleTrimListResource($trims);
    }
}
