<?php

namespace App\Repositories;

use App\Facades\Site;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\VehicleOffer;

class SitemapRepository
{
    public function getSitemap()
    {
        $sitemap = Page::query()->with('descendants')
            ->whereNull('parent_id')
            ->whereNull('category')
            ->active()
            ->get()
            ->map(fn($page) => [
                'url' => Site::url($page)
            ]
        $blog = Page::query()->with('descendants')
            ->where('category', 'blog')->active()->get();
        $news = Page::query()->with('descendants')
            ->where('category', 'news')->active()->get();
        $newCars = NewCar::query()->active()->get();
        $offers = VehicleOffer::query()->get();
        // todo: add srp and top level SRP sections


        return $sitemap;
    }
}
