<?php

namespace Tests\Data;

use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\ContentElement;
use Mtc\ContentManager\Models\ContentElementField;

class ContentElementSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        ContentElement::reguard();
        ContentElement::query()->truncate();
        ContentElementField::query()->truncate();
        collect($this->getList())
            ->each(fn($entry) => ContentElement::query()->create($entry));

        // Now add all fields
        collect($this->getList())
            ->filter(fn($entry) => !empty($entry['fields']))
            ->each(function ($entry) {
                /** @var ContentElement $element */
                $element = ContentElement::query()->where('slug', $entry['slug'])->first();
                collect($entry['fields'])
                    ->each(function ($field) use ($element) {
                        if (!empty($field['child_element_id'])) {
                            $field['child_element_id'] = ContentElement::query()
                                ->where('slug', $field['child_element_id'])
                                ->firstOrFail()
                                ->id;
                        }
                        $element->fields()->create($field);
                    });
            });
    }

    public function getList()
    {
        return [
            [
                'title' => 'Homepage Hero',
                'slug' => 'hero',
                'category' => 'content',
                'ui_component' => 'UiHero',
                'icon' => 'stars',
                'data' => [
                    "order" => 0,
                    "fieldId" => "checkbox_list",
                    "nestable" => false,
                    "componentName" => false,
                    "component" => false,
                    "nestedLimit" => null,
                    "editable" => true,
                    "globalContent" => false,
                    "repeatable" => false,
                    "optionsMenuVisible" => false,
                    "isGroup" => true,
                    "error" => null
                ],
                'fields' => [
                    [
                        'field_type' => 'image',
                        'name' => 'Image',
                        'slug' => 'image',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "image",
                            "componentName" => "ImageUpload",
                            "component" => "EditableContentImageUpload",
                            'icon' => 'image',
                            'meta' => [
                                'options' => [
                                    'maxCount' => 1,
                                ]
                            ]
                        ],
                    ],
                    [
                        'field_type' => 'text',
                        'name' => 'Title',
                        'slug' => 'title',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "text",
                            "componentName" => "TextField",
                            "component" => "EditableContentTextField",
                            'icon' => 'text',
                        ],
                    ],
                    [
                        'child_element_id' => 'search-widget',
                        'field_type' => 'element',
                        'name' => 'Search',
                        'slug' => 'search',
                    ],
                    [
                        'child_element_id' => 'brand-list',
                        'field_type' => 'element',
                        'name' => 'Brand list',
                        'slug' => 'brands',
                    ],
                ]
            ],
            [
                'title' => 'Brand list',
                'slug' => 'brand-list',
                'category' => 'automotive',
                'ui_component' => 'UiBrands',
                'icon' => 'cars',
                'data' => [
                    "order" => 0,
                    "meta" => [
                        "content" => null,
                        "options" => ["items" => [], "useApi" => true, "apiUrl" => "api/data/makes"]
                    ],
                    "fieldId" => "checkbox_list",
                    "nestable" => false,
                    "componentName" => "CheckboxList",
                    "component" => "EditableContentCheckboxList",
                    "nestedLimit" => null,
                    "editable" => true,
                    "globalContent" => false,
                    "repeatable" => false,
                    "optionsMenuVisible" => false,
                    "isGroup" => false,
                    "error" => null
                ]
            ],
            [
                'title' => 'Search',
                'slug' => 'search-widget',
                'category' => 'automotive',
                'ui_component' => 'UiSearch',
                'icon' => 'magnifying-glass',
                'data' => [
                    "order" => 0,
                    "fieldId" => "group",
                    "nestable" => false,
                    "componentName" => false,
                    "component" => false,
                    "nestedLimit" => null,
                    "editable" => true,
                    "globalContent" => false,
                    "repeatable" => false,
                    "optionsMenuVisible" => false,
                    "isGroup" => false,
                    "error" => null
                ]
            ],
            [
                'title' => 'Featured Vehicles',
                'slug' => 'featured-vehicles',
                'drag_and_drop' => 1,
                'category' => 'vehicle',
                'ui_component' => 'UiResponsiveProductList',
                'icon' => 'cars',
            ],
            [
                'title' => 'Call to actions',
                'slug' => 'call-to-action-list',
                'icon' => 'presentation-screen',
                'category' => 'content',
                'drag_and_drop' => 1,
                'ui_component' => 'UiArticlesList',
                'fields' => [
                    [
                        'child_element_id' => 'call-to-action',
                        'field_type' => 'element',
                        'slug' => 'call-to-action',
                        'name' => 'Call To Action',
                    ],
                ],
            ],
            [
                'title' => 'Recent Articles',
                'slug' => 'recent-articles',
                'drag_and_drop' => 1,
                'category' => 'content',
                'icon' => 'newspaper',
                'ui_component' => 'UiArticlesSlider',
                'fields' => [
                    [
                        'field_type' => 'select',
                        'name' => 'Article type',
                        'slug' => 'article-type',
                        'data' => [
                            "fieldId" => "select",
                            "nestable" => false,
                            "repeatable" => false,
                            "componentName" => "SelectField",
                            "component" => "EditableContentSelectField",
                            'icon' => 'list-dropdown',
                            'meta' => [
                                "content" => "news:News articles blog:Blog posts",
                                "options" => [
                                    "items" => [
                                        [
                                            "name" => "News articles",
                                            "value" => "news"
                                        ],
                                        [
                                            "name" => "Blog posts",
                                            "value" => "blog"
                                        ]
                                    ],
                                ],
                                "required" => true
                            ]
                        ],
                    ],
                ]
            ],
            [
                'title' => 'Call To Action',
                'slug' => 'call-to-action',
                'category' => 'content',
                'ui_component' => 'UiArticleCard',
                'icon' => 'stars',
                'data' => [
                    "order" => 0,
                    "fieldId" => "element",
                    "nestable" => true,
                    "componentName" => false,
                    "component" => false,
                    "nestedLimit" => null,
                    "editable" => true,
                    "globalContent" => false,
                    "repeatable" => false,
                    "optionsMenuVisible" => false,
                    "isGroup" => true,
                    "error" => null
                ],
                'fields' => [
                    [
                        'field_type' => 'image',
                        'name' => 'Image',
                        'slug' => 'image',
                        'data' => [
                            "fieldId" => "image",
                            "componentName" => "ImageUpload",
                            "component" => "EditableContentImageUpload",
                            'icon' => 'image',
                            'meta' => [
                                'options' => [
                                    'maxCount' => 1,
                                ]
                            ]
                        ],
                    ],
                    [
                        'field_type' => 'text',
                        'name' => 'Title',
                        'slug' => 'title',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "text",
                            "componentName" => "TextField",
                            "component" => "EditableContentTextField",
                            'icon' => 'text',
                        ],
                    ],
                    [
                        'field_type' => 'text',
                        'name' => 'Action text',
                        'slug' => 'label',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "text",
                            "componentName" => "TextField",
                            "component" => "EditableContentTextField",
                            'icon' => 'text',
                        ],
                    ],
                    [
                        'field_type' => 'text',
                        'name' => 'Link',
                        'slug' => 'url',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "text",
                            "componentName" => "TextField",
                            "component" => "EditableContentTextField",
                            'icon' => 'text',
                        ],
                    ],
                ]
            ],
            [
                'title' => 'Menu tile',
                'slug' => 'menu',
                'category' => 'navigation',
                'fields' => [
                    [
                        'field_type' => 'image',
                        'name' => 'Promo Image',
                        'slug' => 'promo-image',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "image",
                            "componentName" => "ImageUpload",
                            "component" => "EditableContentImageUpload",
                            'icon' => 'image',
                            'meta' => [
                                'options' => [
                                    'maxCount' => 1,
                                ]
                            ]
                        ],
                    ],
                    [
                        'field_type' => 'text',
                        'name' => 'Promo Image Title',
                        'slug' => 'promo-title',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "text",
                            "componentName" => "TextField",
                            "component" => "EditableContentTextField",
                            'icon' => 'text',
                        ],
                    ],
                    [
                        'field_type' => 'text',
                        'name' => 'Promo link',
                        'slug' => 'promo-link',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "text",
                            "componentName" => "TextField",
                            "component" => "EditableContentTextField",
                            'icon' => 'text',
                        ],
                    ],
                    [
                        'field_type' => 'text',
                        'name' => 'Bottom entry text',
                        'slug' => 'bottom-title',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "text",
                            "componentName" => "TextField",
                            "component" => "EditableContentTextField",
                            'icon' => 'text',
                        ],
                    ],
                    [
                        'field_type' => 'text',
                        'name' => 'Bottom entry link',
                        'slug' => 'bottom-link',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "text",
                            "componentName" => "TextField",
                            "component" => "EditableContentTextField",
                            'icon' => 'text',
                        ],
                    ],
                ]
            ],
            [
                'title' => 'Title',
                'slug' => 'title',
                'icon' => 'text',
                'category' => 'simple',
                'ui_component' => 'UiArticleTitle',
                'drag_and_drop' => 1,
                'fields' => [
                    [
                        'field_type' => 'text',
                        'name' => 'Title',
                        'slug' => 'title',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "text",
                            "componentName" => "TextField",
                            "component" => "EditableContentTextField",
                            'icon' => 'text',
                        ],
                    ],
                ]
            ],
            [
                'title' => 'Text',
                'slug' => 'text',
                'icon' => 'font-case',
                'category' => 'simple',
                'ui_component' => 'UiArticleText',
                'drag_and_drop' => 1,
                'fields' => [
                    [
                        'field_type' => 'editor',
                        'name' => 'text',
                        'slug' => 'text',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "text",
                            "componentName" => "TextField",
                            "component" => "EditableContentTextField",
                            'icon' => 'text',
                        ],
                    ],
                ]
            ],
            [
                'title' => 'Banner',
                'slug' => 'banner',
                'icon' => 'image',
                'ui_component' => 'UiArticleBanner',
                'drag_and_drop' => 1,
                'fields' => [
                    [
                        'field_type' => 'image',
                        'name' => 'Image',
                        'slug' => 'image',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "image",
                            "componentName" => "ImageUpload",
                            "component" => "EditableContentImageUpload",
                            'icon' => 'image',
                            'meta' => [
                                'options' => [
                                    'maxCount' => 1,
                                ]
                            ]
                        ],
                    ],
                ]
            ],
            [
                'title' => 'News Page Heading',
                'slug' => 'news-page-list',
                'icon' => 'newspaper',
                'category' => 'content',
                'ui_component' => 'UiNewsCardList',
                'fields' => [
                    [
                        'field_type' => 'select',
                        'name' => 'Article type',
                        'slug' => 'article-type',
                        'data' => [
                            "fieldId" => "select",
                            "componentName" => "SelectField",
                            "component" => "EditableContentSelectField",
                            'icon' => 'list-dropdown',
                            'meta' => [
                                "content" => "news:News articles blog:Blog posts",
                                "options" => [
                                    "items" => [
                                        [
                                            "name" => "News articles",
                                            "value" => "news"
                                        ],
                                        [
                                            "name" => "Blog posts",
                                            "value" => "blog"
                                        ]
                                    ],
                                ],
                                "required" => true
                            ]
                        ],
                    ],
                ]
            ],
        ];
    }
}
