<?php

namespace App\Tracking;

use App\Facades\Settings;
use Illuminate\Contracts\Support\Arrayable;

class SnapchatTracker implements Arrayable
{
    public function toArray()
    {
        $pixelId = Settings::get('tracking-snapchat-pixel-id');
        return [
            [
                "body" => '!function(win, doc, sdk_url){'
                    . 'if(win.snaptr) return; '
                    . 'var tr = win.snaptr = function(){'
                    . '  tr.handleRequest ? tr.handleRequest.apply(tr, arguments) : tr.queue.push(arguments);'
                    . '};'
                    . 'tr.queue = [];'
                    . 'var s = "script";'
                    . 'var new_script_section = doc.createElement(s);'
                    . 'new_script_section.async = true;'
                    . 'new_script_section.src = sdk_url;'
                    . 'var insert_pos = doc.getElementsByTagName(s)[0];'
                    . 'insert_pos.parentNode.insertBefore(new_script_section, insert_pos);'
                    . '}(window, document, "https://sc-static.net/scevent.min.js");'

                    . 'snaptr("track", "PAGE_VIEW");'

                    . 'var noscript = document.createElement("noscript");'
                    . 'var img = document.createElement("img");'
                    . 'img.setAttribute("height", "1");'
                    . 'img.setAttribute("width", "1");'
                    . 'img.setAttribute("style", "display:none;");'
                    . 'img.setAttribute("alt", "");'
                    . 'img.setAttribute("src", "https://tr.snapchat.com/collect/?pid=' . $pixelId . '&ev=PAGE_VIEW'
                    . '&url=" + encodeURIComponent(window.location.href));'
                    . 'noscript.appendChild(img);'
                    . 'document.body.appendChild(noscript);',
                'data-consent' => 'marketing'
            ]
        ];
    }
}
