<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\BodyStyleType;
use Mtc\MercuryDataModels\FuelType;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleMake;
use Tests\TestCase;

class TestTopTaxonomies extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testTopMakes()
    {
        $m1 = VehicleMake::factory()->create();
        $m2 = VehicleMake::factory()->create();
        $m3 = VehicleMake::factory()->create();
        Vehicle::factory(5)->create(['make_id' => $m1->id, 'is_published' => true]);
        Vehicle::factory(7)->create(['make_id' => $m2->id, 'is_published' => true]);
        Vehicle::factory(3)->create(['make_id' => $m3->id, 'is_published' => true]);

        $response = $this->asTenant(tenant())
            ->postJson(route('top-taxonomies'), [
                'taxonomies' => ['makes']
            ]);
        $response->assertStatus(200);
        $this->assertArrayHasKey('makes', $response->json());
        $this->assertCount(3, $response->json('makes'));
        $this->assertEquals(7, $response->json('makes.0.count'));
        $this->assertEquals($m2->slug, $response->json('makes.0.slug'));
        $this->assertEquals(5, $response->json('makes.1.count'));
        $this->assertEquals($m1->slug, $response->json('makes.1.slug'));
    }

    public function testTopBodyTypes()
    {
        $t1 = BodyStyleType::factory()->create();
        $t2 = BodyStyleType::factory()->create();
        $t3 = BodyStyleType::factory()->create();
        Vehicle::factory(5)->create(['body_style_id' => $t1->id, 'is_published' => true]);
        Vehicle::factory(7)->create(['body_style_id' => $t2->id, 'is_published' => true]);
        Vehicle::factory(3)->create(['body_style_id' => $t3->id, 'is_published' => true]);

        $response = $this->asTenant(tenant())
            ->postJson(route('top-taxonomies'), [
                'taxonomies' => ['body_types']
            ]);
        $response->assertStatus(200);
        $this->assertArrayHasKey('body_types', $response->json());
        $this->assertCount(3, $response->json('body_types'));
        $this->assertEquals(7, $response->json('body_types.0.count'));
        $this->assertEquals($t2->slug, $response->json('body_types.0.slug'));
        $this->assertEquals(5, $response->json('body_types.1.count'));
        $this->assertEquals($t1->slug, $response->json('body_types.1.slug'));
    }

    public function testFuelBodyTypes()
    {
        $t1 = FuelType::factory()->create();
        $t2 = FuelType::factory()->create();
        $t3 = FuelType::factory()->create();
        Vehicle::factory(5)->create(['fuel_type_id' => $t1->id, 'is_published' => true]);
        Vehicle::factory(7)->create(['fuel_type_id' => $t2->id, 'is_published' => true]);
        Vehicle::factory(3)->create(['fuel_type_id' => $t3->id, 'is_published' => true]);

        $response = $this->asTenant(tenant())
            ->postJson(route('top-taxonomies'), [
                'taxonomies' => ['fuel_types']
            ]);
        $response->assertStatus(200);
        $this->assertArrayHasKey('fuel_types', $response->json());
        $this->assertCount(3, $response->json('fuel_types'));
        $this->assertEquals(7, $response->json('fuel_types.0.count'));
        $this->assertEquals($t2->slug, $response->json('fuel_types.0.slug'));
        $this->assertEquals(5, $response->json('fuel_types.1.count'));
        $this->assertEquals($t1->slug, $response->json('fuel_types.1.slug'));
    }
}
