<?php

namespace App\Http\Requests;

use App\Facades\Settings;
use Illuminate\Foundation\Http\FormRequest;

class CapFinanceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Settings::get('finance-front-end-calculator-enabled') === true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'cap_id' => [
                'required',
            ],
            'term' => [
                'required',
                'numeric',
            ],
            'price' => [
                'required',
                'numeric',
            ],
            'deposit' => [
                'required',
                'numeric',
            ],
            'annual_mileage' => [
                'required',
                'numeric',
            ],
            'credit_rating' => [
                'required',
            ],
        ];
    }
}
