<?php

namespace App\Tracking;

use App\Facades\Settings;
use Illuminate\Contracts\Support\Arrayable;

class LinkedInTracker implements Arrayable
{
    public function toArray()
    {
        $code = Settings::get('tracking-linkedin-code');
        return [
            [
                "body" => '_linkedin_partner_id = "' . $code . '";'
                    . 'window._linkedin_data_partner_ids = window._linkedin_data_partner_ids || [];'
                    . 'window._linkedin_data_partner_ids.push(_linkedin_partner_id);'

                    . '(function(l) {'
                    . 'if (!l){window.lintrk = function(a,b){window.lintrk.q.push([a,b])};'
                    . 'window.lintrk.q=[]}'
                    . 'var s = document.getElementsByTagName("script")[0];'
                    . 'var b = document.createElement("script");'
                    . 'b.type = "text/javascript";b.async = true;'
                    . 'b.src = "https://snap.licdn.com/li.lms-analytics/insight.min.js";'
                    . 's.parentNode.insertBefore(b, s);})(window.lintrk);'

                    . 'var noscript = document.createElement("noscript");'
                    . 'var img = document.createElement("img");'
                    . 'img.setAttribute("height", "1");'
                    . 'img.setAttribute("width", "1");'
                    . 'img.setAttribute("style", "display:none;");'
                    . 'img.setAttribute("alt", "");'
                    . 'img.setAttribute("src", "https://px.ads.linkedin.com/collect/?pid=' . $code . '&fmt=gif");'
                    . 'noscript.appendChild(img);'
                    . 'document.body.appendChild(noscript);'
                ,
                'data-consent' => 'marketing'
            ]
        ];
    }
}
