<?php

namespace App\Http\Controllers;

use App\Http\Requests\CapFinanceRequest;
use App\Http\Requests\FinanceRequest;
use Illuminate\Http\Response;
use Mtc\MercuryDataModels\Services\FinanceService;
use Mtc\MercuryDataModels\Vehicle;

class FinanceController extends Controller
{
    public function store(FinanceRequest $request, Vehicle $vehicle, FinanceService $service): Response
    {
        return response($service->get($vehicle, $request->validated()));
    }

    public function getForCap(CapFinanceRequest $request, FinanceService $service): Response
    {
        return response($service->getForCapId($request->input('cap_id'), $request->input('price')));
    }
}
