<?php

namespace App\Http\Controllers;

use App\Http\Requests\DerivativeLookupRequest;
use App\Http\Requests\LookupRequest;
use App\Http\Resources\LookupResource;
use Illuminate\Http\Response;
use Mtc\VehicleLookup\VehicleLookupService;

class LookupController extends Controller
{
    public function show(LookupRequest $request, VehicleLookupService $lookupService): LookupResource
    {
        $lookup = $lookupService->findByVRM(
            $request->input('registration_number'),
            $request->input('mileage')
        );

        return new LookupResource($lookup);
    }

    public function getVariants(DerivativeLookupRequest $request, VehicleLookupService $service): Response
    {
        return response($service->findVariants($request->make(), $request->model()));
    }
}
