<?php

namespace App\Http\Controllers;

use App\Http\Resources\VehicleResource;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Mtc\Filter\Facades\Filter;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehiclePrintLog;

class VehiclePrintingController extends Controller
{
    public function search()
    {
        return Filter::handle();
    }

    public function logBatchPrintRequest(Request $request): array
    {
        if ($request->has('vehicle_slugs')) {
            $vehicle_data = collect($request->input('vehicle_slugs'))->map(function ($slug) {
                $vehicle = Vehicle::query()->where('slug', '=', $slug)->first();

                if ($vehicle) {
                    $this->addVehiclePrintLog($vehicle);
                    return new VehicleResource($vehicle);
                }

                return null;
            })->filter();
        }

        return [
            'vehicles' => $vehicle_data
        ];
    }

    private function addVehiclePrintLog(Vehicle $vehicle)
    {
        VehiclePrintLog::query()->create([
            'vehicle_id' => $vehicle->id,
            'price' => $vehicle->price,
            'printed_at' => Carbon::now(),
        ]);
    }
}
