<?php

namespace App\Http\Middleware;

use Closure;
use App\Facades\Settings;
use Illuminate\Http\Request;

class VehiclePrintingAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @param  string|null  ...$guards
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next, ...$guards)
    {
        if (Settings::get('automotive-vehicle-printing-enabled') !== true) {
            return response('Forbidden', 403);
        }

        if (
            Settings::get('automotive-vehicle-printing-password-enabled') === true
            && !$this->passwordIsValid($request)
        ) {
            return response('Access Denied', 401);
        }

        return $next($request);
    }

    private function passwordIsValid(Request $request): bool
    {
        return $request->has('password')
            && $request->input('password') == Settings::get('automotive-vehicle-printing-password');
    }
}
