<?php

namespace App\Http\Resources;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Collection;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\Models\MediaSize;
use Mtc\MercuryDataModels\Form;

class GlobalContentResource extends JsonResource
{
    public static $wrap = '';
    public function toArray($request): array
    {
        $this->resource->load('mediaUses.media');
        return collect($this->resource->content)
            ->map(fn($entry) => $this->mapContent($entry, $request))
            ->toArray();
    }

    private function mapContent($entry, $request)
    {
        if (isset($entry['field_type']) && $entry['field_type'] === 'form-field') {
            $entry['content'] = (new FormViewResource(Form::query()->find($entry['content'])))
                ->setValues([
                    'offer_id' => $request->input('offer_id'),
                    'vehicle_id' => $request->input('vehicle_id'),
                    'page_id' => $request->input('page_id'),
                    'valuation_id' => $request->input('valuation_id'),
                ]);
        }
        if (isset($entry['field_type']) && $entry['field_type'] === 'image') {
            $entry['content'] = $this->resource->mediaUses
                ->filter(fn(MediaUse $mediaUse) => in_array($mediaUse->media_id, $entry['content'] ?? []))
                ->map(fn(MediaUse $mediaUse) => [
                    'src' => $mediaUse->getUrl('square-tile'),
                    'sizes' => $this->allSizesForUse($this->resource, $mediaUse),
                    'alt' => $mediaUse->alt_text,
                    'caption' => $mediaUse->caption,
                    'title' => $mediaUse->title,
                ]);
        }
        if (!empty($entry['children'])) {
            $entry['children'] = collect($entry['children'])->map(fn($child) => $this->mapContent($child, $request));
        }
        return $entry;
    }
    private function allSizesForUse(Model $content, MediaUse $mediaUse): Collection
    {
        if (!isset($this->mediaSizes)) {
            $this->mediaSizes = MediaSize::query()
                ->where('model', 'global-content')
                ->get();
        }
        return $this->mediaSizes
            ->keyBy('label')
            ->map(fn(MediaSize $size) => $mediaUse->getUrl($size->label))
            ->put('original', $mediaUse->media->getOriginalUrlAttribute());
    }
}
