<?php

namespace App\Http\Controllers;

use App\Http\Resources\GlobalContentResource;
use App\Http\Resources\PageResource;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Mtc\ContentManager\Models\Page;
use Mtc\MercuryDataModels\GlobalContent;

class PageController extends Controller
{
    /**
     * Show page detail
     *
     * @param $page
     * @return PageResource
     */
    public function show($pageSlug): PageResource
    {
        // Not using binding in route as to allow for Seo Redirect middleware
        $page = Page::query()->where('slug', $pageSlug)->active()->firstOrFail();
        return new PageResource($page);
    }

    public function globalContent($slug)
    {
        return Cache::remember(tenant('id') . "-global-content-$slug", $this->cacheLife(), function () use ($slug) {
            return new GlobalContentResource(GlobalContent::query()
                ->where('slug', $slug)
                ->firstOrFail());
        });
    }

    private function cacheLife(): Carbon
    {
        return Carbon::now()->addMinutes(app()->environment('production') ? 60 : 0);
    }
}
