<?php

namespace App\Http\Controllers;

use App\Facades\Settings;
use App\Http\Resources\SiteResource;
use Illuminate\Http\Request;

class SiteController extends Controller
{
    /**
     * Show page detail
     *
     * @param $page
     * @return SiteResource
     */
    public function index(): SiteResource
    {
        return new SiteResource([]);
    }

    public function checkAccess(Request $request)
    {
        return $request->input('password') === Settings::get('site-access-password')
            ? response('Access Granted')
            : response('Access Denied', 403);
    }
}
